/*
 * Decompiled with CFR 0.152.
 */
package ui2;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.ProgressBarTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import mp3.ID3Tag;
import ui2.ConversionTask;
import ui2.UIStage;

public class Lame
extends UIStage {
    private static final URL DEFAULT_PICTURE = Lame.class.getResource("picture.png");
    @FXML
    private ImageView cover;
    @FXML
    private Button doRemove;
    @FXML
    private Button doEncodeDecode;
    @FXML
    private Button saveTags;
    @FXML
    private TableView<ConversionTask> files;
    @FXML
    private TableColumn<ConversionTask, Double> progressColumn;
    @FXML
    private ComboBox<String> presets;
    @FXML
    private ComboBox<String> vbr;
    @FXML
    private ComboBox<String> algorithm;
    @FXML
    private ComboBox<Integer> cbr;
    @FXML
    private ComboBox<Integer> abr;
    @FXML
    private RadioButton setCBR;
    @FXML
    private RadioButton setABR;
    @FXML
    private RadioButton setVBR;
    @FXML
    private RadioButton stereo;
    @FXML
    private RadioButton jointStereo;
    @FXML
    private RadioButton forcedJointStereo;
    @FXML
    private RadioButton dualChannels;
    @FXML
    private RadioButton mono;
    @FXML
    private RadioButton auto;
    @FXML
    private RadioButton outputIsInput;
    @FXML
    private RadioButton customOutputDir;
    @FXML
    private TextField outputDir;
    @FXML
    private CheckBox overwrite;
    @FXML
    private ComboBox<String> title;
    @FXML
    private ComboBox<String> artist;
    @FXML
    private ComboBox<String> album;
    @FXML
    private ComboBox<String> year;
    @FXML
    private ComboBox<String> track;
    @FXML
    private ComboBox<String> genre;
    @FXML
    private ComboBox<String> comment;
    private ObservableList<ConversionTask> convertableFiles = FXCollections.observableArrayList();
    private ObservableList<String> presetsList = FXCollections.observableArrayList();
    private ObservableList<Integer> cbrList = FXCollections.observableArrayList();
    private ObservableList<String> vbrList = FXCollections.observableArrayList();
    private ObservableList<Integer> abrList = FXCollections.observableArrayList();
    private ObservableList<String> algorithmList = FXCollections.observableArrayList();
    private ObservableList<String> genreList = FXCollections.observableArrayList();
    private String coverFilename;
    private File lastDir;
    private FileChooser.ExtensionFilter musicFilter = new FileChooser.ExtensionFilter("MUSIC (WAV, MP3)", new String[]{"*.wav", "*.mp3"});

    @FXML
    private void add() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.lastDir);
        fileDialog.getExtensionFilters().add((Object)this.musicFilter);
        List selectedFiles = fileDialog.showOpenMultipleDialog(this.files.getScene().getWindow());
        if (selectedFiles != null) {
            this.lastDir = ((File)selectedFiles.get(0)).getParentFile();
            for (File file : selectedFiles) {
                ConversionTask convertableFile = new ConversionTask();
                convertableFile.setNo(this.convertableFiles.size());
                convertableFile.setFile(file);
                this.convertableFiles.add((Object)convertableFile);
            }
        }
    }

    @FXML
    private void remove() {
        this.convertableFiles.removeAll((Collection)this.files.getSelectionModel().getSelectedItems());
    }

    @FXML
    private void setPresets() {
        this.setPresetsOrCustom(true);
    }

    @FXML
    private void setCustom() {
        this.setPresetsOrCustom(false);
    }

    @FXML
    private void encodeDecode() {
        for (ConversionTask service : this.files.getItems()) {
            try {
                service.setCmd(this.getCommand(service.getFile()));
                service.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void chooseOutputDir() {
        DirectoryChooser fileDialog = new DirectoryChooser();
        fileDialog.setInitialDirectory(this.lastDir);
        File selectedFile = fileDialog.showDialog(this.files.getScene().getWindow());
        if (selectedFile != null) {
            this.lastDir = selectedFile.getParentFile();
            this.outputDir.setText(selectedFile.getAbsolutePath());
            this.customOutputDir.setSelected(true);
        }
    }

    @FXML
    private void setPicture() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.lastDir);
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("JPG file", new String[]{"*.jpg"}));
        File selectedFile = fileDialog.showOpenDialog(this.files.getScene().getWindow());
        this.coverFilename = null;
        this.cover.setImage(new Image(DEFAULT_PICTURE.toString()));
        if (selectedFile != null) {
            this.lastDir = selectedFile.getParentFile();
            try {
                this.coverFilename = selectedFile.getAbsolutePath();
                this.cover.setImage(new Image(selectedFile.toURI().toURL().toString()));
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
    }

    @FXML
    private void doSaveTags() {
        for (ConversionTask service : this.files.getItems()) {
            if (!"mp3".equals(service.getType())) continue;
            File file = service.getFile();
            File newFile = new File(file.getParentFile(), file.getName().substring(0, file.getName().lastIndexOf(46)) + ".new.mp3");
            try {
                service.setCmd(this.getSaveTagsCommand(file, newFile));
                service.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void initialize() {
        this.progressColumn.setCellFactory(ProgressBarTableCell.forTableColumn());
        this.files.setItems(this.convertableFiles);
        this.presets.setItems(this.presetsList);
        this.cbr.setItems(this.cbrList);
        this.vbr.setItems(this.vbrList);
        this.abr.setItems(this.abrList);
        this.algorithm.setItems(this.algorithmList);
        this.genre.setItems(this.genreList);
        this.presetsList.addAll((Object[])new String[]{this.util.getBundle().getString("PRESET_MEDIUM"), this.util.getBundle().getString("PRESET_STANDARD"), this.util.getBundle().getString("PRESET_EXTREME"), this.util.getBundle().getString("PRESET_INSANE"), this.util.getBundle().getString("PRESET_STANDARD")});
        this.presets.getSelectionModel().select((Object)this.util.getBundle().getString("PRESET_STANDARD"));
        this.cbrList.addAll((Object[])new Integer[]{320, 256, 224, 192, 160, 128, 112, 96, 80, 64, 56, 48, 40, 32, 192});
        this.cbr.getSelectionModel().select((Object)192);
        this.vbrList.addAll((Object[])new String[]{this.util.getBundle().getString("VBR_0"), this.util.getBundle().getString("VBR_1"), this.util.getBundle().getString("VBR_2"), this.util.getBundle().getString("VBR_3"), this.util.getBundle().getString("VBR_4"), this.util.getBundle().getString("VBR_5"), this.util.getBundle().getString("VBR_6"), this.util.getBundle().getString("VBR_7"), this.util.getBundle().getString("VBR_8"), this.util.getBundle().getString("VBR_9")});
        this.vbr.getSelectionModel().select((Object)this.util.getBundle().getString("VBR_2"));
        for (int i = 310; i >= 8; --i) {
            this.abrList.add((Object)i);
        }
        this.abr.getSelectionModel().select((Object)192);
        this.algorithmList.addAll((Object[])new String[]{this.util.getBundle().getString("ALG_0"), this.util.getBundle().getString("ALG_1"), this.util.getBundle().getString("ALG_2"), this.util.getBundle().getString("ALG_3"), this.util.getBundle().getString("ALG_4"), this.util.getBundle().getString("ALG_5"), this.util.getBundle().getString("ALG_6"), this.util.getBundle().getString("ALG_7"), this.util.getBundle().getString("ALG_8"), this.util.getBundle().getString("ALG_9"), this.util.getBundle().getString("ALG_AUTO")});
        this.algorithm.getSelectionModel().select((Object)this.util.getBundle().getString("ALG_2"));
        this.genreList.add((Object)"");
        ID3Tag id3 = new ID3Tag();
        id3.id3tag_genre_list((num, name) -> this.genreList.add((Object)name));
        this.files.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.saveTags.setDisable(this.files.getSelectionModel().getSelectedItems().size() == 0));
        this.cover.setImage(new Image(DEFAULT_PICTURE.toString()));
    }

    private void setPresetsOrCustom(boolean isPresets) {
        this.presets.setDisable(!isPresets);
        this.setCBR.setDisable(isPresets);
        this.setABR.setDisable(isPresets);
        this.setVBR.setDisable(isPresets);
        this.cbr.setDisable(isPresets);
        this.abr.setDisable(isPresets);
        this.vbr.setDisable(isPresets);
    }

    private ArrayList<String> getSaveTagsCommand(File file, File newFile) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("--space-id3v1");
        if (this.title.getSelectionModel().getSelectedItem() != null) {
            cmd.add("--tt");
            cmd.add((String)this.title.getSelectionModel().getSelectedItem());
        }
        if (this.artist.getSelectionModel().getSelectedItem() != null) {
            cmd.add("--ta");
            cmd.add((String)this.artist.getSelectionModel().getSelectedItem());
        }
        if (this.album.getSelectionModel().getSelectedItem() != null) {
            cmd.add("--tl");
            cmd.add((String)this.album.getSelectionModel().getSelectedItem());
        }
        if (this.year.getSelectionModel().getSelectedItem() != null) {
            cmd.add("--ty");
            cmd.add((String)this.year.getSelectionModel().getSelectedItem());
        }
        if (this.track.getSelectionModel().getSelectedItem() != null) {
            cmd.add("--tn");
            cmd.add((String)this.track.getSelectionModel().getSelectedItem());
        }
        if (((String)this.genre.getSelectionModel().getSelectedItem()).length() > 0) {
            cmd.add("--tg");
            cmd.add((String)this.genre.getSelectionModel().getSelectedItem());
        }
        if (this.comment.getSelectionModel().getSelectedItem() != null) {
            cmd.add("--tc");
            cmd.add((String)this.comment.getSelectionModel().getSelectedItem());
        }
        if (this.coverFilename != null) {
            cmd.add("--ti");
            cmd.add(this.coverFilename);
        }
        cmd.add(file.getAbsolutePath());
        cmd.add(newFile.getAbsolutePath());
        return cmd;
    }

    private ArrayList<String> getCommand(File file) throws IOException {
        String outDir;
        String a;
        ArrayList<String> cmd = new ArrayList<String>();
        if (file.getName().toLowerCase(Locale.US).endsWith(".mp3")) {
            cmd.add("--decode");
        }
        cmd.add("--embedded");
        cmd.add("--silent");
        if (!this.presets.isDisabled()) {
            String pr = String.valueOf(this.presets.getSelectionModel().getSelectedItem());
            cmd.add("--preset");
            cmd.add(pr.substring(0, pr.indexOf(32)).toLowerCase(Locale.US));
        } else if (this.setVBR.isSelected()) {
            String v = String.valueOf(this.vbr.getSelectionModel().getSelectedItem());
            if (v.indexOf(32) != -1) {
                v = v.substring(0, v.indexOf(32));
            }
            cmd.add("-v");
            cmd.add("-V");
            cmd.add(v);
        } else if (this.setABR.isSelected()) {
            a = String.valueOf(this.abr.getSelectionModel().getSelectedItem());
            cmd.add("--abr");
            cmd.add(a);
        } else {
            a = String.valueOf(this.cbr.getSelectionModel().getSelectedItem());
            cmd.add("--cbr");
            cmd.add("-b");
            cmd.add(a);
        }
        String eaq = String.valueOf(this.algorithm.getSelectionModel().getSelectedItem());
        if (!"Auto".equals(eaq)) {
            if (eaq.indexOf(32) != -1) {
                eaq = eaq.substring(0, eaq.indexOf(32));
            }
            cmd.add("-q");
            cmd.add(eaq);
        }
        if (this.stereo.isSelected()) {
            cmd.add("-m");
            cmd.add("s");
        } else if (this.jointStereo.isSelected()) {
            cmd.add("-m");
            cmd.add("j");
        } else if (this.forcedJointStereo.isSelected()) {
            cmd.add("-m");
            cmd.add("f");
        } else if (this.dualChannels.isSelected()) {
            cmd.add("-m");
            cmd.add("d");
        } else if (this.mono.isSelected()) {
            cmd.add("-m");
            cmd.add("m");
        }
        cmd.add(file.getAbsolutePath());
        String outName = file.getName();
        outName = outName.toLowerCase(Locale.US).endsWith(".mp3") ? outName.substring(0, outName.lastIndexOf(46)) + ".wav" : outName.substring(0, outName.lastIndexOf(46)) + ".mp3";
        if (!this.outputIsInput.isSelected()) {
            outDir = this.outputDir.getText();
            if (outDir.length() == 0) {
                outDir = System.getProperty("user.dir");
            }
        } else {
            outDir = file.getParent();
        }
        cmd.add(new File(outDir, outName).getAbsolutePath());
        if (!this.overwrite.isSelected() && new File(outDir, outName).exists()) {
            throw new IOException("Output file " + new File(outDir, outName) + " already exists!");
        }
        return cmd;
    }
}

